<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Fonctionnaire\FonctionnairController;
use App\Http\Controllers\Fonctionnaire\Auth\NewPasswordController;
use App\Http\Controllers\Fonctionnaire\Auth\VerifyEmailController;
use App\Http\Controllers\Fonctionnaire\Auth\PasswordResetLinkController;
use App\Http\Controllers\Fonctionnaire\Auth\ConfirmablePasswordController;
use App\Http\Controllers\Fonctionnaire\Auth\AuthenticatedSessionController;
use App\Http\Controllers\Fonctionnaire\Auth\EmailVerificationPromptController;
use App\Http\Controllers\Fonctionnaire\Auth\EmailVerificationNotificationController;

/*
|--------------------------------------------------------------------------
| Admin Routes
|--------------------------------------------------------------------------
*/

Route::prefix('fonctionnaire')->name("fonctionnaire.")->group(static function () {

    // Guest routes
    Route::middleware('guest:fonctionnaire')->group(static function () {
        // Auth routes
        Route::get('login', [AuthenticatedSessionController::class, 'create'])->name('login');
        Route::post('login', [AuthenticatedSessionController::class, 'store']);
        // Forgot password
        Route::get('forgot-password', [PasswordResetLinkController::class, 'create'])->name('password.request');
        Route::post('forgot-password', [PasswordResetLinkController::class, 'store'])->name('password.email');
        // Reset password
        Route::get('reset-password/{token}', [NewPasswordController::class, 'create'])->name('password.reset');
        Route::post('reset-password', [NewPasswordController::class, 'store'])->name('password.update');
    });

    // Verify email routes
    Route::middleware(['auth:fonctionnaire'])->group(static function () {
        Route::get('verify-email', [EmailVerificationPromptController::class, '__invoke'])->name('verification.notice');
        Route::get('verify-email/{id}/{hash}', [VerifyEmailController::class, '__invoke'])->middleware(['signed', 'throttle:6,1'])->name('verification.verify');
        Route::post('email/verification-notification', [EmailVerificationNotificationController::class, 'store'])->middleware('throttle:6,1')->name('verification.send');
    });

    // Authenticated routes
    Route::middleware(['auth:fonctionnaire'])->group(static function () {
        // Confirm password routes
        Route::get('confirm-password', [ConfirmablePasswordController::class, 'show'])->name('password.confirm');
        Route::post('confirm-password', [ConfirmablePasswordController::class, 'store']);
        // Logout route
        Route::post('logout', [AuthenticatedSessionController::class, 'destroy'])->name('logout');
        // General routes
        Route::get('/', [FonctionnairController::class, 'index'])->name('index');
    Route::get('profile', [FonctionnairController::class, 'profile'])->middleware('password.confirm.fonctionnaire')->name('profile');
});

});

