<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Demande de changement de filière</title>
    <style>
        body {
            font-family: sans-serif;
            margin: 40px;
            position: relative;
        }

        .header-images {
        text-align: center;
        margin-bottom: 10px;
    }
        
        h1 {
            text-align: center;
            text-transform: uppercase;
            margin-bottom: 40px;
        }
        table {
        width: 100%;
        border-collapse: collapse;
        font-size: 14px;
        margin-bottom: 40px;
    }
    td.label {
        font-weight: bold;
        width: 30%;
        padding: 10px 12px;
        background-color: #f0f0f0;
        border: 1px solid #ddd;
        vertical-align: middle;
    }
    td.value {
        border: 1px solid #ddd;
        padding: 10px 12px;
        text-align: center;
        font-size: 15px;
        vertical-align: middle;
    }
    td.label.arabic {
        font-weight: bold;
        text-align: right;
        direction: rtl;
        padding-right: 12px;
        background-color: #f0f0f0;
        border: 1px solid #ddd;
        vertical-align: middle;
    }
    .footer {
            position: fixed;
            bottom: 40px;
            right: 40px;
            text-align: right;
            font-style: italic;
            font-size: 13px;
        }
    </style>
</head>
<body>

    

    <h2 style="text-align: center;">Demande de changement de filière  (<?= $date ?>) </h2>

    <!-- Header with logos -->
    <div class="header-images">
        <img src="<?= $left_logo ?>" alt="Left Logo" style="height: 150px; ">
    </div>
    <table>
    <tr>
        <td class="label">Apogée</td>
        <td class="value"><?= htmlspecialchars($apogee) ?></td>
        <td class="label arabic">أبوجي</td>
    </tr>
    <tr>
        <td class="label">Nom</td>
        <td class="value"><?= htmlspecialchars($nom) ?></td>
        <td class="label arabic">النسب</td>
    </tr>
    <tr>
        <td class="label">Prénom</td>
        <td class="value"><?= htmlspecialchars($prenom) ?></td>
        <td class="label arabic">اسم</td>
    </tr>
    <tr>
        <td class="label">Ancienne filière</td>
        <td class="value"><?= htmlspecialchars($ancienne_filiere) ?></td>
        <td class="label arabic">الشعبة القديمة</td>
    </tr>
    <tr>
        <td class="label">Nouvelle filière</td>
        <td class="value"><?= htmlspecialchars($nouvelle_filiere) ?></td>
        <td class="label arabic">الشعبة الجديدة</td>
    </tr>
    </table>
        <div class="barcode">
            <img src="<?= $barcode_path ?>" alt="Code-barres" height="130">
        </div>
        <br>
        
        <table>
    <tr>
        <td class="label">Signature d'étudiant</td>
        <td class="value"></td>
        <td class="label arabic">توقيع الطالب</td>
    </tr>
    </table>
        

    <hr style="border: none; height: 2px; background-color: black;">
    
    
        <h2 style="text-align: center;">Reçu  de demande de changement de filière (<?= htmlspecialchars($date) ?>)</h2>
        <table>
        <tr>
            <td class="label">Apogée</td>
            <td class="value"><?= htmlspecialchars($apogee) ?></td>
            <td class="label arabic">أبوجي</td>
        </tr>
        <tr>
            <td class="label">Nom</td>
            <td class="value"><?= htmlspecialchars($nom) ?></td>
            <td class="label arabic">النسب</td>
        </tr>
        <tr>
            <td class="label">Prénom</td>
            <td class="value"><?= htmlspecialchars($prenom) ?></td>
            <td class="label arabic">اسم</td>
        </tr>
        <tr>
            <td class="label">Ancienne filière</td>
            <td class="value"><?= htmlspecialchars($ancienne_filiere) ?></td>
            <td class="label arabic">الشعبة القديمة</td>
        </tr>
        <tr>
            <td class="label">Nouvelle filière</td>
            <td class="value"><?= htmlspecialchars($nouvelle_filiere) ?></td>
            <td class="label arabic">الشعبة الجديدة</td>
        </tr>
    </table>
    <div class="footer">
        Cachet de l’administration
    </div>

</body>
</html>
