@extends('etudiant.dashboard')

@section('etudiant')
<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<div class="content-page">
    <!-- Start content -->
    <div class="content">
        <div class="container">

            <div class="row">
                <div class="col-xs-12">
                    <div class="page-title-box">
                        <h4 class="page-title">Changement de Filière</h4>

                        <div class="clearfix"></div>

                    </div>
                </div>
            </div>
            <!-- end row -->
            @if($etape==0)

            <div class="row">
                <div class="col-xs-12 col-lg-12 col-xl-12">
                    <div class="card-box">
                        <h4 style="margin-top: 0; margin-bottom: 20px;">Ancienne Filière</h4>
                        <div style="padding: 20px;">
                            <p><strong>Nom :</strong> {{ Auth::guard('etudiant')->user()->nom }}</p>
                            <p><strong>Prénom :</strong> {{ Auth::guard('etudiant')->user()->prenom }}</p>
                            <p><strong>Filière :</strong>
                                {{ Auth::guard('etudiant')->user()->filiere_get_id->libelle_diplome ?? 'N/A' }}</p>
                        </div>
                        <hr>
                        <h4 style="margin-top: 0; margin-bottom: 20px;">Nouvelle filière</h4>
                        <div class="row">
                            <div class="col-lg-12 col-sm-12 col-xs-12 col-md-12 col-xl-6">
                                <form action="{{route('etudiant.nouvellefiliere')}}" method="post">
                                    @csrf
                                    <select class="form-control" name="nouvellefiliere"
                                        aria-label=".form-select-lg example">
                                        <option selected disabled>Choisissez votre ancien filière</option>
                                        @foreach ($listFilieres as $filiere )

                                        <option value="{{$filiere[1]}}">{{$filiere[1]}}</option>

                                        @endforeach
                                    </select>
                                    <br>
                                    <input type="submit" class="btn btn-success" value="Confirmer">
                                    <br><br>
                                </form>
                            </div>
                        </div>

                    </div>
                </div><!-- end col-->
            </div>
            <!-- end row -->


            @elseif($etape==1)
            <div class="row">
                <div class="col-xs-12 col-lg-12 col-xl-12">
                    <div class="card-box">
                        <h4 class="header-title m-t-0 m-b-20">Reçu : </h4>
                        <div class="container" style="display: flex; justify-content: center;">
                            <div class="col-lg-12 col-sm-12 col-xs-12 col-md-12 col-xl-6">
                                <form action="{{route('etudiant.telecharger_recu')}}" method="post">
                                    @csrf
                                    <br>
                                    <input type="submit" class="btn btn-primary" value="Télécharger le Reçu"
                                        style="width: 80%;">
                                    <br><br>
                                </form>

                                <form action="{{route('etudiant.deleteChagefiliere')}}" method="post">
                                    @csrf
                                    <br>
                                    <input type="submit" class="btn btn-danger" value="Modifier le choix"
                                        style="width: 80%;">
                                    <br><br>
                                </form>
                            </div>
                        </div>
                    </div>
                </div><!-- end col-->
            </div>

            <!-- end row -->
            @endif

        </div> <!-- container -->

    </div> <!-- content -->

</div>
<!-- End content-page -->
@endsection