@include('etudiant.includes.header_account')

    <div class="account-bg">
        <div class="card-box m-b-0">
            <div class="text-xs-center m-t-20">
                <a href="{{ route('etudiant.login') }}" class="logo">
                                    <h1 style="cursor: pointer; display: flex; justify-content: center; align-items: center; padding: 1px; margin: 1px; color:#007bff;">Login Etudiant</h1>

                    <img src="{{ asset('assets/images/logo.png') }}" height="234" width="160" />
                </a>
            </div>
            <div class="m-t-30 m-b-20">
                <form class="form-horizontal m-t-20" method="POST" action="{{ route("etudiant.login") }}">
                    @csrf

                    @error('id')
                        <p id="loginError" class="text-danger text-xs-center m-b-20"
                           style="cursor: pointer; display: flex; justify-content: space-between; align-items: center; padding: 10px; margin: 1px; border: 1px solid #EA5B6F; background-color:#F5CBCB; border-radius: 4px;">
                            <span>{{ $message }}</span>
                            <button onclick="document.getElementById('loginError').style.display='none'" 
                                    style="background: none; border: none; font-size: 16px; font-weight: bold; cursor: pointer; color: #EA5B6F;">&times;</button>
                        </p>
                    @enderror

                    <div class="form-group ">
                        <div class="col-xs-12">
                            <x-text-input id="id" class="form-control" type="text" name="id" :value="old('id')" placeholder="Codeapogee" required autofocus autocomplete="id" />
                        </div>
                    </div>

                    <div class="form-group">
                        <div class="col-xs-12 position-relative">
                            <div class="input-group">
                                <x-text-input 
                                    id="password"
                                    class="form-control" 
                                    type="password" 
                                    name="password" 
                                    placeholder="code massar" 
                                    autocomplete="current-password"
                                />
                                
                                <span class="input-group-text" 
                                      onclick="togglePassword()" 
                                      style="cursor: pointer; display: flex; justify-content: center; align-items: center; padding: 1px; margin: 1px; border: 1px solid #007bff; border-radius: 4px;">
                                    <i id="togglePasswordIcon" class="fa fa-eye" style="color: #007bff;"></i>
                                </span>
                            </div>
                        </div>
                    </div>


                    
                    <div class="form-group">
    <div class="col-xs-12" style="text-align: center;">
        Conformément à la loi 09-08, vous disposez d'un droit d'accès, de rectification et d'opposition au traitement de vos données personnelles.
    </div>
    <div style="text-align: center; margin-top: 10px;">
        <a class="underline" href="https://www.fsjeste.ma/site/conditions-dutilisation/" target="_blank">
            les Conditions Générales d'Utilisation
        </a>
    </div>
</div>


                    <div class="form-group text-center m-t-30">
                        <div class="col-xs-12">
                            <button class="btn btn-primary btn-block waves-effect waves-light" type="submit">Connecter
                            </button>
                        </div>
                    </div>

                </form>

            </div>
        </div>
    </div>
    <!-- end card-box-->
    </div>
    <!-- end wrapper page -->
    <script>
function togglePassword() {
    const passwordInput = document.getElementById("password");
    const icon = document.getElementById("togglePasswordIcon");

    if (passwordInput.type === "password") {
        passwordInput.type = "text";
        icon.classList.remove("fa-eye");
        icon.classList.add("fa-eye-slash");
    } else {
        passwordInput.type = "password";
        icon.classList.remove("fa-eye-slash");
        icon.classList.add("fa-eye");
    }
}
</script>

@include('etudiant.includes.footer_account')
