<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('etudiants', function (Blueprint $table) {
            $table->integer("id")->primary();
            $table->string('cne');
            $table->string('cin');
            $table->string('nom');
            $table->string('prenom');
            $table->string('email')->nullable();
            $table->string('password');
            $table->string('date_naissance');
            $table->enum('password_change', ['Oui', 'Non'])->default('Non');
            $table->enum('stuation_annuel', ['Inscrit', 'Non'])->default('Non');
            $table->enum('stuation_autmn',['Inscrit','Fraud','Validé','Non'])->default('Inscrit');
            $table->enum('stuation_print',['Inscrit','Fraud','Validé','Non'])->default('Inscrit');
            $table->integer('filiere_id');
            $table->foreign('filiere_id')->references('filiere_id')->on('filieres');
            $table->string('diplome');
            $table->rememberToken();
            $table->timestamps();

        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('etudiants');
    }
};
