<?php

namespace App\Http\Controllers\Professeur;

use App\Http\Controllers\Controller;
use App\Models\Convocation;
use App\Models\Etudiant;
use App\Models\Ip;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\Seance;
use App\Models\ReclamationNote;
use App\Models\Parametre;


class ProfesseurController extends Controller
{
    public function index() {
        // Get the logged-in professor
        $professor = Auth::guard("professeur")->user()->id;

        // Fetch seances with corresponding lib_module from modules table
        $seances = Seance::where('id_professeur', $professor)
            ->join('sections', 'seances.id_section', '=', 'sections.id')
            ->join('modules', 'sections.code_module', '=', 'modules.id')
            ->where(function($query) {
                $query->where('seances.id_section', 'like', '____2____')
                      ->orWhere('seances.id_section', 'like', '____4____')
                      ->orWhere('seances.id_section', 'like', '____6____');
            })
            ->select('seances.*', 'modules.lib_module')
            ->get();

        return view('professeur.reclamations', compact('seances'));
        //return view("professeur.index");
    }

    public function reclamations() {
        // Get the logged-in professor
        $professor = Auth::guard("professeur")->user()->id;
        // Fetch seances with corresponding lib_module from modules table
        $seances = Seance::where('id_professeur', $professor)
            ->join('sections', 'seances.id_section', '=', 'sections.id')
            ->join('modules', 'sections.code_module', '=', 'modules.id')
            ->where(function($query) {
                $query->where('seances.id_section', 'like', '____2____')
                      ->orWhere('seances.id_section', 'like', '____4____')
                      ->orWhere('seances.id_section', 'like', '____6____');
            })
            ->select('seances.*', 'modules.lib_module')
            ->get();

        return view('professeur.reclamations', compact('seances'));
    }

    public function showReclamationList($section) {
        if(preg_match('/automn/i', Parametre::first()->session)){
            if (preg_match('/^[A-Z]{4}1\d{3}[A-Z]$/', $section) || preg_match('/^[A-Z]{4}3\d{3}[A-Z]$/', $section) || preg_match('/^[A-Z]{4}5\d{3}[A-Z]$/', $section)) {
                return redirect('/professeur');
            }
        }else{
            if (preg_match('/^[A-Z]{4}2\d{3}[A-Z]$/', $section) || preg_match('/^[A-Z]{4}4\d{3}[A-Z]$/', $section) || preg_match('/^[A-Z]{4}6\d{3}[A-Z]$/', $section)) {
                return redirect('/professeur');
            }
        }
        // Efficiently fetch reclamation notes for the specified section
        $reclamations = ReclamationNote::whereHas('ip_get_id', function ($query) use ($section) {
            $query->where('id_section', $section);
            $query->where('etat_reclamation', 'En attente de la réponse du professeur');
            $session = Parametre::first()->session_reclamation;
            $query->whereIn('id_ip', Ip::select("id")->where('session', $session));
        })->get();
        // Pass the reclamations to the view for display
        // $convocations=Convocation::all();
        // $ips=Ip::all();
        return view('professeur.reclamations_list', compact('reclamations'));
    }
}
