<?php

namespace App\Http\Controllers\Etudiant;

use PDF;
use App\Models\Ip;
use Carbon\Carbon;
use App\Models\Filiere;
use App\Models\Etudiant;
use App\Models\Parametre;
use App\Models\Convocation;
use App\Models\Confirmation;
use Illuminate\Http\Request;
use App\Models\ReclamationNote;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use SimpleSoftwareIO\QrCode\Facades\QrCode;
use PHPUnit\Framework\MockObject\Rule\Parameters;
use App\Models\FiliereParametre;
use App\Models\ChangeFiliere;
use Milon\Barcode\DNS1D;




class EtudiantController extends Controller
{
    use EtudiantTrait;

    // facade

    public function index()
    {
        // $param_confirm = $this->parameter_confirmation();
        $etudiant = Etudiant::with('filiere_get_id')->get();
        $filiere = Filiere::with('etudiants')->get();
        return view('etudiant.index', compact('etudiant', 'filiere'));
    }
    public function profile()
    {
        return view('etudiant.profile');
    }

    public function changement_filiere(Request $request){
        $FiliereParametre = FiliereParametre::first()->etat;
        if($FiliereParametre==0){
            return redirect()->route('etudiant.index');
        }

        $etudiantId = Auth::guard('etudiant')->user()->id;
        $changeFiliere = ChangeFiliere::where('id', $etudiantId)->first();

        if ($changeFiliere) {
            $nouvelle_filiere = $changeFiliere->nouvelle_filiere;
            $etape=1;
            return view('etudiant.changement_filiere',compact("etape"));
            
        } else {
            $etape = 0;
            $listFilieres = [
                ["PLMR", "Filière Management des Ressources Humaines"],
                ["PLCM", "Filière Commerce et Marketing"],
                ["PLCF", "Filière Comptabilité", "Finance et Fiscalité"],
                ["PLME", "Filière Management des établissements"],
                ["PLEC", "Filière Économétrie"],
                ["PLMD", "FILIÈRE MÉTIERS DU DROIT ET DE LA JUSTICE"],
                ["PLEP", "Filière Etudes Politiques et Internationales"],
                ["PLDF", "Filière Droit Financier et des Affaires"],
                ["PLEA", "Filière Etudes Administratives et Financières"],
                ["PLPJ", "مسلك المهن القانونية والقضائية"],
                ["PLDA", "مسلك قانون المال والأعمال"],
                ["PLIF", "مسلك الوسيط الأسري"],
                ["PLPI","مسلك الدراسات السياسية والدولية"],
                ["PLAF", "مسلك الدراسات الإدارية و المالية"],
                ["PLGE", "Gestion"],
                ["PLEG", "Economie et Gestion"],
                ["PLFV", "Droit Privé en français"],
                ["PLFP", "Droit Public en français"],
                ["PLAV", "Droit Privé en arabe"],
                ["PLAP", "Droit Public en arabe"],
                ["PFDA", "Droit arabe"],
                ["PFEG", "Economie et Gestion"],
                ["PFDF", "Droit français"],
                ["PFGS", "Gestion"],
                ["PFPA", "Droit Privé en arabe"],
                ["PFGA", "Droit Public en arabe"],
                ["PFPF", "Droit Privé en français"],
                ["PFGF", "Droit Public en français"]
            ];

            return view('etudiant.changement_filiere',compact("etape", "listFilieres"));
        }
    }

    

    public function nouvellefiliere(Request $request){
        $data["id"] = Auth::guard('etudiant')->user()->id;
        $data["ancien_filiere"] = Auth::guard('etudiant')->user()->filiere_get_id->libelle_diplome;
        ChangeFiliere::create($data);
        $etape=1;
        $etudiantId = Auth::guard('etudiant')->user()->id;
        $changeFiliere = ChangeFiliere::where('id', $etudiantId)->first();
        $changeFiliere->nouvelle_filiere = $request->nouvellefiliere;
        $changeFiliere->save();
        
        
        return redirect()->route('etudiant.changement_filiere',compact("etape"));
    }


    public function deleteChagefiliere(Request $request){
        $etudiantId = Auth::guard('etudiant')->user()->id;
        ChangeFiliere::destroy($etudiantId);
        return redirect()->route('etudiant.changement_filiere');
    }


    public function telecharger_recu(Request $request){

        $png = QrCode::format('png')->size(200)->generate(Auth::guard('etudiant')->user()->id);
        $base64 = base64_encode($png);
        
        $barcode = new DNS1D();
        $barcode->setStorPath(__DIR__ . "/cache/");
        $imgSrc = 'data:image/png;base64,' . $barcode->getBarcodePNG("123456789", "C39");
        
        $data = [
            'apogee' => Auth::guard('etudiant')->user()->id,
            'nom' => Auth::guard('etudiant')->user()->nom,
            'prenom' => Auth::guard('etudiant')->user()->prenom,
            'ancienne_filiere' => Auth::guard('etudiant')->user()->diplome,
            'nouvelle_filiere' => ChangeFiliere::where("id", Auth::guard('etudiant')->user()->id)->first()->nouvelle_filiere,
            'barcode_path' => $imgSrc,
            'left_logo' => public_path('logo.png'),
            'right_logo' => public_path('logo.png'),
            'date' => "2024/2025"
        ];
        
        $pdf = PDF::loadView('pdf.document', $data);
        $mpdf = $pdf->getMpdf(); // Access the mPDF instance
        
        $mpdf->SetWatermarkText('FSJESTE');
        $mpdf->showWatermarkText = true;
        $mpdf->watermarkTextAlpha = 0.05;
        
        return $pdf->stream('document.pdf');
    }


    

    public function viewConfirmation()
    {
        // $param_confirm = $this->parameter_confirmation();
        if($this->checkconfirmation()==null)
            return abort(404);
        $confirm = $this->checkconfirmation()["confirm"];
        return view("etudiant.confirmation",compact('confirm'));
    }

    public function PostConfirmation(Request $request){
      if(Auth::user()->stuation_annuel=="Inscrit" && (Auth::user()->stuation_autmn=="Inscrit" || Auth::user()->stuation_print=="Inscrit")){
            $data["apogee"]=Auth::guard('etudiant')->user()->id;
            $data["session"]=$this->checkconfirmation()["session"];
            $data["confirm"]=1;
            Confirmation::create($data);
            return redirect()->back();
        }else{
            return redirect()->back();
        }
    }
    
    
    public function ip(){
        $param=Parametre::first();
        if($param->session=="automn"){
            $queryIps = Ip::where("codeapo", Auth::guard("etudiant")->user()->id)
                ->where("session", Parametre::first()->session_examen)
                ->where("id", "not like", "_____5%")
                ->where("id", "not like", "_____1%")
                ->where("id", "not like", "_____3%")
                ->get();
            return view('etudiant.ip', compact('queryIps'));
        }else{
            $queryIps = Ip::where("codeapo", Auth::guard("etudiant")->user()->id)
                ->where("session", Parametre::first()->session_examen)
                ->where("id", "like", "_____5%")
                ->where("id", "like", "_____1%")
                ->where("id", "like", "_____3%")
                ->get();
            return view('etudiant.ip', compact('queryIps'));
        }
    }

    public function convocation() {
        $param=Parametre::first();
        if($param != null  && $param->convocation==1) {
            $queryConvocation=Convocation::where("id",">","321016")->whereIn('id_ip', Ip::select('id')->where('codeapo',Auth::guard('etudiant')->user()->id)->get())->where("session",$param->session_examen)->orderBy('id', 'asc')->get();
            return view('etudiant.convocation', compact("queryConvocation"));
        }
        abort(404);
    }
    
    
   public function pdfconvocation(){
    $param=Parametre::first();
    if($param != null  && $param->convocation==1){
        $queryConvocation=Convocation::where("id",">","321016")->whereIn('id_ip',
        Ip::select('id')->where('codeapo',Auth::guard('etudiant')->user()->id)->get())->where("session",$param->session_examen)->orderBy('id', 'asc')->get();
        $qrcode = QrCode::size(100)->generate(Auth::guard('etudiant')->user()->id."\n".
        Auth::guard('etudiant')->user()->cne."\n".Auth::guard('etudiant')->user()->nom."\n".
        Auth::guard('etudiant')->user()->prenom
        );
            $data = [
                'queryConvocation' => $queryConvocation,
                'qrcode'=>$qrcode
                ];
            $pdf = PDF::loadView('etudiant.pdfconvocation', $data);
            return $pdf->stream('pdfconvocation.pdf');
    }
    abort(404);
  }
   
   
    public function reclamationNote(){
        $param=Parametre::first();
        if($param != null  && $param->reclamation_note==1) {
            if($param->session=="automn"){
                $queryReclamtionNote = Ip::where("codeapo", Auth::guard("etudiant")->user()->id)
                                        ->where("session", $param->session_reclamation)
                                        ->where("id", "not like", "_____5%")
                                        ->where("id", "not like", "_____1%")
                                        ->where("id", "not like", "_____3%")
                                        ->whereNotIn('id',ReclamationNote::select('id_ip')->get())
                                        ->get();
                $querygetReclamations = ReclamationNote::whereIn('id_ip',Ip::select('id')
                                        ->where("session", $param->session_reclamation)
                                        ->where("id", "not like", "_____5%")
                                        ->where("id", "not like", "_____1%")
                                        ->where("id", "not like", "_____3%")
                                        ->where('codeapo',Auth::guard("etudiant")->user()->id)->get())
                                        ->get();
                return view("etudiant.reclamationNote",compact(['queryReclamtionNote','querygetReclamations']));
            }else{
                $queryReclamtionNote = Ip::where("codeapo",Auth::guard("etudiant")->user()->id)
                                        ->where("session", $param->session_reclamation)
                                        ->where("id", "like", "_____5%")
                                        ->where("id", "like", "_____1%")
                                        ->where("id", "like", "_____3%")
                                        ->whereNotIn('id',ReclamationNote::select('id_ip')->get())
                                        ->get();
                $querygetReclamations = ReclamationNote::whereIn('id_ip',Ip::select('id')
                                        ->where("session", $param->session_reclamation)
                                        ->where("id", "like", "_____5%")
                                        ->where("id", "like", "_____1%")
                                        ->where("id", "like", "_____3%")
                                        ->where('codeapo',Auth::guard("etudiant")->user()->id)->get())
                                        ->get();
                return view("etudiant.reclamationNote",compact(['queryReclamtionNote','querygetReclamations']));
            }
            
        }
        abort(404);
    }
    
    
    public function reclamer(Request $request){
        $request->validate([
            'reclamer'=>["required"],
         ]);
       $countConvocation=Convocation::where('id_ip',$request->reclamer)->count();
       $module=Ip::where('id',$request->reclamer)->first();
       return view("etudiant.reclamationNote_post",compact(['countConvocation','module']));
    }
        
        
    public function backtoreclamer(Request $request){
        $request->validate([
          'type_reclamation' => ['required'],
        ]);
        $salle="NULL";
        if($request->salle!=null){
            $request->validate([
            'salle' => ['required', 'string', 'max:25'],
        ]);
        $salle=$request->salle;
        }
        $data = [
            'salle_examen' => $salle,
            'type_reclamation' => $request->type_reclamation,
            'id_ip' => $request->idip,
            'date_reclamation' => Carbon::now()->format('d/m/Y'), // format date properly
            'codeapo' => Auth::guard("etudiant")->user()->id // Assuming this provides the required value
        ];
        ReclamationNote::create($data);
        return to_route("etudiant.reclamationNote");
    }
}
